<?php
/**
 * the template for displaying all posts.
 */
get_header();

get_template_part( 'template-parts/banner/content', 'banner-single' );
$infinite_scroll_items = '3';
$infinite_scroll = 'no';

$recipe_switch = qoxag_meta_option(get_the_ID(), 'recipe_switch', 'no');


$blog_details_layout_overwrite = qoxag_meta_option(get_the_ID(), 'post_details_layout_overwrite', 'no');
if($blog_details_layout_overwrite == 'yes') {
	$qoxag_blog_details_layout = qoxag_meta_option(get_the_ID(), 'qoxag_blog_details_layout');
} else {
	$qoxag_blog_details_layout = qoxag_option('qoxag_blog_details_layout', 'style1');
}

$blog_details_social_share_show = qoxag_option('blog_details_social_share_show', 'yes');
$blog_details_tags_show = qoxag_option('blog_details_tags_show', 'yes');

$blog_sidebar = qoxag_option('blog_details_sidebar', 'no-sidebar');
$column = ($blog_sidebar == 'no-sidebar') ? 'col-lg-10 mx-auto' : 'col-lg-8 col-md-12 mx-auto';

$blog_sidebar_class = '';
if($blog_sidebar != 'no-sidebar') {
	$blog_sidebar_class = 'sidebar-active';
} else {
	$blog_sidebar_class = 'sidebar-inactive';
}

$banner_class = '';

$blog_show_banner = qoxag_option('blog_single_show_banner');
$show_breadcrumb = qoxag_option('blog_single_show_breadcrumb');
$infinite_scroll = qoxag_option('blog_single_infinite_scroll', 'no');
$infinite_scroll_items = qoxag_option('blog_single_infinite_scroll_items', '3');
$single_post_content_top_ads = qoxag_option('single_post_content_top_ads');

if($blog_show_banner != 'yes') {
	$banner_class = ' nobanner-main-container';
}

?>

    <div id="main-content"
         class="main-container blog-single <?php echo esc_attr($blog_sidebar_class); ?><?php echo esc_attr($banner_class); ?> banner-bg-<?php echo esc_attr($qoxag_blog_details_layout); ?>"
         role="main">
		<?php if($infinite_scroll == 'yes') { ?>

			<?php if($qoxag_blog_details_layout == 'style3' || $qoxag_blog_details_layout == 'style4') { ?>
                <div class="main-post-header-bg">
                    <div class="container">
						<?php while(have_posts()) : the_post(); ?>
							<?php
							if(defined('DEVM')) {
								if($show_breadcrumb == 'yes' && $blog_show_banner != 'yes') {
									?>
                                    <div class="nobanner-breadcrumb d">
										<?php qoxag_get_breadcrumbs(); ?>
                                    </div>
									<?php
								}
							}
							?>
							<?php get_template_part('template-parts/blog/contents/single/header', $qoxag_blog_details_layout); ?>
						<?php endwhile; ?>
                    </div>
                </div>
			<?php } ?>
            <div class="container">
				<?php if($qoxag_blog_details_layout != 'style3' && $qoxag_blog_details_layout != 'style4' && $qoxag_blog_details_layout != 'style5') { ?>
					<?php
					if(defined('DEVM')) {
						if($show_breadcrumb == 'yes' && $blog_show_banner != 'yes') {
							?>
                            <div class="nobanner-breadcrumb dd">
								<?php qoxag_get_breadcrumbs(); ?>
                            </div>
							<?php
						}
					}
				}
				?>
				<?php while(have_posts()) : the_post(); ?>
                    <div id="blog-ajax-load-more-container">
                        <div class="infinty-loadmore-wrap ajax-loader-current-url"
                             data-current-url="<?php echo get_the_permalink(); ?>">

                            <div class="row scroll-content">
								<?php if($blog_sidebar == 'left-sidebar') {
									get_sidebar();
								} ?>

                                <div class="<?php echo esc_attr($column); ?>">
                                    <article
                                            id="post-<?php the_ID(); ?>" <?php post_class(["post-content", "post-single"]); ?>>
										<?php get_template_part('template-parts/blog/contents/single/content', $qoxag_blog_details_layout); ?>
                                    </article>

									<?php
									if($blog_details_social_share_show == 'yes') {
										if(shortcode_exists('xs_social_share')) { ?>
                                            <div class="social-share">
                                                <h4 class="social-share-title"><?php echo esc_html__('Share This:', 'qoxag'); ?></h4>
												<?php echo do_shortcode('[xs_social_share]'); ?>
                                            </div>
											<?php
										}
									} ?>

									<?php
									if($blog_details_tags_show == 'yes') {
										qoxag_tag_list();
									} ?>

									<?php qoxag_post_nav(); ?>

									<?php get_template_part('template-parts/blog/post-parts/part', 'author'); ?>
									<?php
									comments_template();
									?>
                                </div>

								<?php if($blog_sidebar == 'right-sidebar') {
									get_sidebar();
								} ?>
                            </div>

							<?php $prev_post = get_previous_post(); ?>
							<?php if($prev_post) { ?>
                                <div class="blog-ajax-load-more-trigger"
                                     data-max-posts="<?php echo esc_attr($infinite_scroll_items); ?>"
                                     data-next-post-url="<?php echo get_permalink($prev_post->ID); ?>"
                                     data-content-loaded="no" data-current-post-number="1">
                                    <i class="xts-icon xts-spinner"></i>
                                </div>
							<?php } ?>
                        </div>
                    </div>
				<?php endwhile; ?>
            </div>

		<?php } else { ?>
			<?php if($qoxag_blog_details_layout == 'style3' || $qoxag_blog_details_layout == 'style4') { ?>
                <div class="main-post-header-bg">
                    <div class="container">
						<?php while(have_posts()) : the_post(); ?>
							<?php
							if(defined('DEVM')) {
								if($show_breadcrumb == 'yes' && $blog_show_banner != 'yes') {
									?>
                                    <div class="nobanner-breadcrumb">
										<?php qoxag_get_breadcrumbs(); ?>
                                    </div>
									<?php
								}
							}
							?>
							<?php get_template_part('template-parts/blog/contents/single/header', $qoxag_blog_details_layout); ?>
						<?php endwhile; ?>
                    </div>
                </div>
			<?php } ?>

            <!-- Post layout style 5 Start -->
			<?php if($qoxag_blog_details_layout == 'style5') : ?>
				<div class="container single-post-<?php echo esc_attr($qoxag_blog_details_layout); ?>">
					<?php while(have_posts()) : the_post(); ?>
						<div class="row">
							<div class="col-lg-12">
								<!-- Single Post ads section -->
								<?php if($single_post_content_top_ads != '') : ?>
									<div class="content-top-advertisment text-center">
										<?php echo do_shortcode($single_post_content_top_ads); ?>
									</div>
								<?php endif; ?>
								<!-- Single post ads section end-->
								<!-- Single post Breadcrumb section -->
								<?php if(defined('DEVM') && $show_breadcrumb == 'yes' && $blog_show_banner != 'yes') : ?>
									<div class="nobanner-breadcrumb">
										<?php qoxag_get_breadcrumbs(); ?>
									</div>
								<?php endif; ?>
								<!-- Single post Breadcrumb section end -->
								<!-- Single post Content start -->
								<article
										id="post-<?php the_ID(); ?>" <?php post_class(["post-content", "post-single"]); ?>>
									<?php get_template_part('template-parts/blog/contents/single/content', $qoxag_blog_details_layout); ?>
								</article>
								<!-- Single post Content end -->
							</div>
						</div>
					<?php endwhile; ?>
				</div>
			<?php else : ?>
			<!-- Post layout style 5 End -->

            <div class="container">
				<?php if($qoxag_blog_details_layout != 'style3' && $qoxag_blog_details_layout != 'style4') { ?>
					<?php
					if($show_breadcrumb == 'yes' && $blog_show_banner != 'yes') {
						?>
                        <div class="nobanner-breadcrumb">
							<?php qoxag_get_breadcrumbs(); ?>
                        </div>
						<?php
					}
				}
				?>

                <div class="row">
					<?php if($blog_sidebar == 'left-sidebar') {
						get_sidebar();
					} ?>
                    <div class="blog-content-wrap <?php echo esc_attr($column); ?>">
                        <div class="single-wrap">
							<?php while(have_posts()) : the_post(); ?>
                                <article
                                        id="post-<?php the_ID(); ?>" <?php post_class(["post-content", "post-single"]); ?>>
									<?php get_template_part('template-parts/blog/contents/single/content', $qoxag_blog_details_layout); ?>
                                </article>

								<?php
								if($blog_details_social_share_show == 'yes') {
									if(shortcode_exists('xs_social_share')) { ?>
                                        <div class="social-share">
                                            <h4 class="social-share-title"><?php echo esc_html__('Share This:', 'qoxag'); ?></h4>
											<?php echo do_shortcode('[xs_social_share]'); ?>
                                        </div>
										<?php
									}
								} ?>

								<?php
								if($blog_details_tags_show == 'yes') {
									qoxag_tag_list();
								} ?>

								<?php qoxag_post_nav(); ?>

								<?php get_template_part('template-parts/blog/post-parts/part', 'author'); ?>
								<?php
								comments_template();
								?>
							<?php endwhile; ?>
                        </div>
                    </div> <!-- .col-md-8 -->
					<?php if($blog_sidebar == 'right-sidebar') {
						get_sidebar();
					} ?>

                </div> <!-- .row -->
				<?php get_template_part('template-parts/blog/post-parts/related', 'post'); ?>
            </div> <!-- .container -->
			<?php endif; ?>
		<?php } ?>
    </div> <!--#main-content -->
<?php get_footer(); ?>